/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.pdf;

import itx.erp.customer.model.Address;
import itx.erp.sales.model.Order;
import itx.erp.sales.model.OrderLine;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.pdf.PdfPage;
import jtbcore.util.NumberUtil;

public class OrderPdf {
    protected Order order;
    protected PdfPage pdf;
    protected float ytop = -1.0f;

    public OrderPdf(Order order) {
        this.setOrder(order);
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void build() throws IOException {
        this.pdf = new PdfPage("test.pdf");
        this.pdf.addPage();
        this.leftHeader();
        this.rightHeader();
        this.topHeader();
        this.renderLines();
        this.renderComment();
    }

    protected void leftHeader() throws IOException {
        float x = 30.0f;
        float y = this.pdf.getPageHeight() - 50.0f;
        this.pdf.writeText(x, y, "1703 SL Heerhugowaard");
        this.pdf.writeText(x, y - 18.0f, "Jacques Perklaan 71");
        this.pdf.writeText(x, y - 36.0f, "Kvknr: 1234576");
        this.pdf.writeText(x, y - 54.0f, "BTW: NL1234560908");
    }

    protected void rightHeader() throws IOException {
        float x = this.pdf.getPageWidth() - 30.0f;
        float y = this.pdf.getPageHeight() - 50.0f;
        this.pdf.writeTextAlignRight(x - 400.0f, y, 400.0f, "Tel: 085 002 0095");
        this.pdf.writeTextAlignRight(x - 400.0f, y - 18.0f, 400.0f, "Mail: info@itxplain.nl");
        this.pdf.writeTextAlignRight(x - 400.0f, y - 36.0f, 400.0f, "NL89INGB 000 732 0463");
    }

    protected void topHeader() throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        float ytop = this.pdf.getPageHeight() - 50.0f;
        this.pdf.setFont("Helvetica-Bold", 18.0f);
        this.pdf.writeText(30.0f, ytop -= 120.0f, "Order");
        this.pdf.setFont("Helvetica", 12.0f);
        this.pdf.writeText(30.0f, ytop -= 30.0f, "Order nummer: " + String.valueOf(this.order.getOrderNumber()));
        if (this.order.getOrderDate() != null) {
            this.pdf.writeText(30.0f, ytop -= 18.0f, "Order datum: " + sdf.format(this.order.getOrderDate()));
        }
        ytop -= 36.0f;
        if (this.order.getCustomer() != null) {
            this.pdf.writeText(30.0f, ytop, this.order.getCustomer().getCustomerName());
            if (this.order.getCustomer().getAddresses().size() > 0) {
                Address a = this.order.getCustomer().getAddresses().get(0);
                String street = a.getStreet() + " " + a.getStreetNo();
                this.pdf.writeText(30.0f, ytop -= 18.0f, street.trim());
                String zipCity = a.getZipcode() + " " + a.getCity();
                this.pdf.writeText(30.0f, ytop -= 18.0f, zipCity);
            } else {
                ytop -= 36.0f;
            }
        } else {
            ytop -= 36.0f;
        }
        this.pdf.writeText(30.0f, ytop -= 36.0f, "Betreft: " + this.order.getSubject());
    }

    protected void renderHeaderLines(float ytop) throws IOException {
        float xtotal = this.pdf.getPageWidth() - 110.0f;
        this.pdf.setFont("Helvetica-Bold", 12.0f);
        this.pdf.writeText(30.0f, ytop, "Omschrijving");
        this.pdf.writeTextAlignRight(250.0f, ytop, 80.0f, "Aantal");
        this.pdf.writeTextAlignRight(330.0f, ytop, 80.0f, "Bedrag");
        this.pdf.writeTextAlignRight(410.0f, ytop, 80.0f, "Btw");
        this.pdf.writeTextAlignRight(xtotal, ytop, 80.0f, "Totaal");
        this.pdf.setFont("Helvetica", 12.0f);
        this.pdf.drawLine(30.0f, ytop - 6.0f, xtotal + 80.0f, ytop - 6.0f);
    }

    protected void renderLines() throws IOException {
        this.ytop = this.pdf.getPageHeight() - 360.0f;
        float xtotal = this.pdf.getPageWidth() - 110.0f;
        this.renderHeaderLines(this.ytop);
        List<OrderLine> lines = this.getOrder().getLines();
        DecimalFormat df = new DecimalFormat("0.00");
        HashMap vatAmounts = new HashMap();
        int x = 0;
        while (x < lines.size()) {
            OrderLine ol = lines.get(x);
            this.ytop -= 18.0f;
            if (this.ytop < 100.0f) {
                this.renderNextpageNotice();
                this.pdf.setFont("Helvetica", 12.0f);
                this.pdf.addPage();
                this.ytop = this.pdf.getPageHeight() - 100.0f;
                this.renderHeaderLines(this.ytop);
                this.ytop -= 18.0f;
            }
            if ("text".equals(ol.getLineType())) {
                this.pdf.writeText(30.0f, this.ytop, ol.getShortDescription());
                this.pdf.writeText(200.0f, this.ytop, ol.getShortDescription2());
            } else {
                this.pdf.writeText(30.0f, this.ytop, ol.getShortDescription());
                if (ol.getAmount() != null) {
                    this.pdf.writeTextAlignRight(250.0f, this.ytop, 80.0f, df.format(ol.getAmount()));
                }
                if (ol.getPriceExclVat() != null) {
                    this.pdf.writeTextAlignRight(330.0f, this.ytop, 80.0f, NumberUtil.formatPrice(ol.getPriceExclVat()));
                }
                String vatp = df.format(ol.getVatPercentage());
                vatp = vatp.replaceAll(".00", "");
                vatp = vatp.replace(".", ",");
                this.pdf.writeTextAlignRight(410.0f, this.ytop, 80.0f, vatp + "%");
                this.pdf.writeTextAlignRight(xtotal, this.ytop, 80.0f, NumberUtil.formatPrice(ol.getTotalInclVat()));
            }
            ++x;
        }
        if (this.ytop < 100.0f) {
            this.renderNextpageNotice();
            this.pdf.setFont("Helvetica", 12.0f);
        }
        this.ytop -= 18.0f;
        this.ytop -= 18.0f;
        this.pdf.writeTextAlignRight(266.0f, this.ytop, 300.0f, "Totaal excl. btw " + NumberUtil.formatPrice(this.getOrder().getTotalCalculatedPrice()));
        Map<Double, Double> vatTotals = this.getOrder().getVatTotals();
        for (Double d : vatTotals.keySet()) {
            this.ytop -= 18.0f;
            String btw = df.format(d);
            btw.replace(".00", "");
            this.pdf.writeTextAlignRight(266.0f, this.ytop, 300.0f, "Btw " + btw + "%");
        }
        this.ytop -= 18.0f;
        this.pdf.writeTextAlignRight(266.0f, this.ytop, 300.0f, "Totaal " + NumberUtil.formatPrice(this.getOrder().getTotalCalculatedPriceInclVat()));
    }

    public void renderComment() throws IOException {
        String c = this.order.getComment();
        if (c == null || c.trim().length() == 0) {
            return;
        }
        this.ytop -= 30.0f;
        if (this.ytop < 100.0f) {
            this.renderNextpageNotice();
        }
        this.pdf.setFont("Helvetica-Bold", 12.0f);
        this.pdf.writeText(30.0f, this.ytop, "Opmerking:");
        this.pdf.setFont("Helvetica", 12.0f);
        this.ytop -= 18.0f;
        this.pdf.writeText(30.0f, this.ytop, c);
    }

    public void renderNextpageNotice() throws IOException {
        this.pdf.setFont("Helvetica-Oblique", 12.0f);
        this.pdf.writeText(185.0f, 45.0f, "Order gaat verder op de volgende pagina");
    }

    public void save(OutputStream os) throws IOException {
        if (this.pdf == null) {
            this.build();
        }
        this.pdf.save(os);
    }

    public void save(String path) throws IOException {
        if (this.pdf == null) {
            this.build();
        }
        this.pdf.save(new File(path));
    }
}

